-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

-- SYNCRO: der Rest wird später geladen
/*INSERT INTO recnocommentkategorie (rck_id, rck_b, rck_gruppe, rck_column, rck_modified)
VALUES
  --- ('art',           'Artikelnummer',   'Stammdaten',   'ak_nr',       '2000-01-01'),  ---   Datensatz ist im DemoDaten.0100.Stamm angelegt
  ('belegdokument', 'Dokument-Nummer', 'Ein- Verkauf', 'beld_dokunr', '2000-01-01');*/

INSERT INTO recnocommentkategorie (rck_id, rck_b, rck_gruppe, rck_column, rck_modified)
  SELECT 'belegdokument', 'Dokument-Nummer', 'Ein- Verkauf', 'beld_dokunr', '2000-01-01'
  WHERE NOT EXISTS ( SELECT true FROM recnocommentkategorie WHERE rck_id = 'belegdokument' );

/*INSERT INTO dokutypes (dt_id, dt_descr, dt_abteilung, dt_linkto, dt_dokident, dt_linkforms, dt_txtnr, dt_dbridsql, dt_parentnodeid, modified_date)
VALUES
  ('zeichnung', 'Zeichnung',          'Artikel', 'art',           NULL,          NULL,            NULL,  NULL,                                                '15', '2000-01-01'),
  ('lfs',       'Lieferschein Kunde', 'Verkauf', 'belegdokument', 'beld_dokunr', 'TFormLFSBeleg', '527', 'SELECT dbrid FROM lieferschein WHERE beld_dokunr=', '26', '2000-01-01');*/

INSERT INTO dokutypes (dt_id, dt_descr, dt_abteilung, dt_linkto, dt_dokident, dt_linkforms, dt_txtnr, dt_dbridsql, dt_parentnodeid, modified_date)
  SELECT 'zeichnung', 'Zeichnung',          'Artikel', 'art',           NULL,          NULL,            NULL,  NULL,                                                '15', '2000-01-01'
  WHERE NOT EXISTS ( SELECT true FROM dokutypes WHERE dt_id = 'zeichnung' );

INSERT INTO dokutypes (dt_id, dt_descr, dt_abteilung, dt_linkto, dt_dokident, dt_linkforms, dt_txtnr, dt_dbridsql, dt_parentnodeid, modified_date)
  SELECT 'lfs',       'Lieferschein Kunde', 'Verkauf', 'belegdokument', 'beld_dokunr', 'TFormLFSBeleg', '527', 'SELECT dbrid FROM lieferschein WHERE beld_dokunr=', '26', '2000-01-01'
  WHERE NOT EXISTS ( SELECT true FROM dokutypes WHERE dt_id = 'lfs' );


DO $$
DECLARE pdid INTEGER;
BEGIN
  -- TODO: Dieses pdr_revision_id in den picndoku-InsertTrigger verschieben, wegen NOT NULL ins DEFAULT -1 und es bei NULL oder -1 ausführen.
  -- Direkt als Funktion im DEFAULT geht nicht, wegen Verzögerung zwischen AfterInsert und INSERT im Delphi.
  -- nextval: INSERT ohne pd_id und stattsessen überall currval+1 kann nicht verwendet werden. (siehe Doku)

  -- Dokumente sind nur verlinkt: auf einheitliche/globale Pfade achten!
  -- S:\Prodat2005\PSQL\Zeichnung.pdf bzw. I:\_USER+LWS\dschuch\LWS\Prodat2005\PSQL\Zeichnung.pdf
  -- pdr_revision_id: DEFAULT für neue Dokumente ohne weitere Revisionen: pdr_revision_id = pd_id

  pdid := nextval('picndoku_pd_id_seq'::regclass);
  -- Revision:
  INSERT INTO picndoku_revision (pdr_revision_id)
  SELECT pdid WHERE NOT exists(SELECT * FROM picndoku_revision WHERE pdr_revision_id = pdid);
  -- Dokument:
  INSERT INTO picndoku (pd_id, pd_tablename, pd_dbrid, pd_doktype, pd_path, pd_dokumentfile, pd_source, pd_revision_id)
  SELECT pdid, 'art', dbrid, 'zeichnung', 'Zeichnung.pdf', E'S:\\Prodat2005\\PSQL\\Zeichnung.pdf', 'file', pdid
  FROM art WHERE ak_nr = 'G.PKW.A-1168534 /A';

  pdid := nextval('picndoku_pd_id_seq'::regclass);
  -- Revision:
  INSERT INTO picndoku_revision (pdr_revision_id)
  SELECT pdid WHERE NOT exists(SELECT * FROM picndoku_revision WHERE pdr_revision_id = pdid);
  -- Dokument:    pd_path wird vom Trigger überschrieben = GETRIEBE-GMBH ~ LS19-00001 (bestätigt)
  INSERT INTO picndoku (pd_id, pd_tablename, pd_dbrid, pd_doktype, pd_path, pd_dokumentfile, pd_source, pd_revision_id)
  SELECT pdid, 'belegdokument', dbrid, 'lfs', 'Zeichnung.pdf', E'S:\\Prodat2005\\PSQL\\Zeichnung.pdf', 'file', pdid
  FROM lieferschein WHERE beld_belegtyp = 'LFS' AND beld_dokunr = 'LS19-00001';
END $$;

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;
